/*
This is a modified version of Sentence highlighter 1.0 by Josip!

Version: 1.12, requires Writemonkey 2.5.0.9 or higher

Release date: November 11th 2013

Author: CF

Description: 
Actively places transparent blinds above and below current paragraph or heading section. Will help you focus on the part of text you are working on. Explore some options in _config.incl file in sh plugin directory.

Installation:
Unzip the "Paragraph Blinds" directory into the plugins directory.

Deployment:
This plugin is initialized at startup. Toggle highlight visibility with CTRL+E,K. 
Use CTRL+E,J to toggle between the three types of blinds: Heading Section, Paragraph and Sentence.
*/

monkey.include("_config.incl");
monkey.include("_config_user.incl");

var point = monkey.richTextBox.GetPositionFromCharIndex(monkey.caretPosition);
var hl = monkey.getBlankPluginForm(0, 0);
hl.showMinimizeButton = false;
hl.allowResize = false;
hl.allowMove = false;
hl.formFallThrough = true;
hl.CanFocus = false;
hl.CanSelect = false;

hl.roundedCorners = 1;
hl.initialOpacity = HIGHLIGHT_OPACITY;
hl.deactivatedOpacity = HIGHLIGHT_OPACITY;

hl.Show();
hl.SetBounds(0, 0, 0, 0);

var rect1 = new System.Drawing.Rectangle();
var rect2 = new System.Drawing.Rectangle();
var rect3 = new System.Drawing.Rectangle();
var rect4 = new System.Drawing.Rectangle();

var enabled = true;

var words = 0;


monkey.add_extendedShortcutFiredE(function(object, eventargs) {
	if (eventargs.extendedKey == TOGGLE_VISIBILITY_KEY) {
		if (enabled) {
			hlHide();
			enabled = false
			monkey.showNotice(HIGHLIGHT_OFF_S, true, false);
		} else {
			enabled = true;
			moveHl();
			monkey.showNotice(HIGHLIGHT_ON_S, true, false);
		}
	} else if (eventargs.extendedKey == TOGGLE_TYPE_KEY) {
		if ( HIGHLIGHT_TYPE == "HeadingSection" ) {
			HIGHLIGHT_TYPE = "Paragraph";
			monkey.showNotice("Paragraph Blinds", true, false);
		} else if( HIGHLIGHT_TYPE == "Paragraph" ) {
			HIGHLIGHT_TYPE = "Sentence";
			monkey.showNotice("Sentence Blinds", true, false);
		} else if( HIGHLIGHT_TYPE == "Sentence" ) {
			HIGHLIGHT_TYPE = "HeadingSection";
			monkey.showNotice("Section Blinds", true, false);	
		} else  {
			HIGHLIGHT_TYPE = "Paragraph";	
		}			
			
	}
});


monkey.richTextBox.add_VScroll(function(object, eventargs) {
	moveHl();

});

monkey.richTextBox.add_MouseDown(function(object, eventargs) {

	monkey.richTextBox.isUpdating = false;
	moveHl();
});

monkey.richTextBox.add_KeyUp(function(object, eventargs) {

	monkey.richTextBox.isUpdating = false;
	moveHl();
});

monkey.richTextBox.add_KeyUp(function(object, eventargs) {
	monkey.richTextBox.isUpdating = false;
	moveHl();
});

monkey.richTextBox.add_Resize(function(object, eventargs) {
	moveHl();
});

monkey.form.add_Resize(function(object, eventargs) {
	monkey.richTextBox.isUpdating = false;
	moveHl();
});

monkey.richTextBox.add_ContentsResized(function(object, eventargs) {
	moveHl();
});

monkey.richTextBox.add_Move(function(object, eventargs) {
	monkey.richTextBox.isUpdating = false;
	moveHl();
});

monkey.form.add_Move(function(object, eventargs) {
	monkey.richTextBox.isUpdating = false;
	moveHl();
});

hl.add_Activated(function(object, eventargs) {
	monkey.richTextBox.Focus();
});

monkey.add_beforeOpenE(function(object, eventargs) {
	hlHide();
});

// Manage soft exit
monkey.form.add_VisibleChanged(function(object, eventargs) {
	if (monkey.form.Visible == false) {
		hlHide();
	} else {
		moveHl();
	}
});


var hlHide = function() {
	if (monkey.richTextBox.isUpdating)
	 	return;
	hl.SetBounds(0, 0, 0, 0);
};

var moveHl = function() {

	if (monkey.richTextBox.isUpdating || !enabled) {
		return;
	}
	var hlX, hlY, hlWidth, hlHeight;
	var b = doHlBounds();
	var sentencePath = new System.Drawing.Drawing2D.GraphicsPath();
	sentencePath.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;

	hl.BackColor = getColorFromName(HIGHLIGHT_COLOR);
	
	sentencePath.AddRectangle(rect1);
	sentencePath.AddRectangle(rect2);	
	
	if ( HIGHLIGHT_TYPE == "Sentence" ) {
		sentencePath.AddRectangle(rect3);
		sentencePath.AddRectangle(rect4);
	}

	hl.SetBounds(b[0], b[1], b[2], b[3]);
	hl.Region = new System.Drawing.Region(sentencePath);

};


var doHlBounds = function() {

	var start,end;

	switch (HIGHLIGHT_TYPE) {
		case "HeadingSection":
			var b = monkey.richTextBox.GetSegmentBounds(4, monkey.selectionStart); 
			// will return string "x/y" on success or "null/null" on error (no section found)
			if (b == "null/null") {
				return [0,0,0,0];
			}
			var bA = b.split("/");
			start = bA[0];
			end = bA[1];
			break;
		case "Paragraph":
			start = monkey.paragraphUnderCaretStart;
			end = monkey.paragraphUnderCaretEnd;
			break;
		case "Sentence":
			start = monkey.getSentenceUnderCaretStart(SENTENCE_START);
			end = monkey.getSentenceUnderCaretEnd(SENTENCE_END);
			break;
		default :
			return [0,0,0,0];
	}
	
	
	var hlX, hlY, hlWidth, hlHeight;
	var lineHeight = ((monkey.richTextBox.SelectionFont.Size + twipsToPixels(monkey.settings["_layoutLineSpacing"])) * monkey.richTextBox.ZoomFactor) / 1.22;

	var startPosition = monkey.richTextBox.GetPositionFromCharIndex(start);
	var startPoint = monkey.richTextBox.PointToScreen(startPosition);

	var endPosition = monkey.richTextBox.GetPositionFromCharIndex(end);
	var endPoint = monkey.richTextBox.PointToScreen(endPosition);

	var rtfBottomPoint = monkey.richTextBox.PointToScreen(new System.Drawing.Point(monkey.richTextBox.Width, monkey.richTextBox.Height));
	var rtfTopPoint = monkey.richTextBox.PointToScreen(new System.Drawing.Point(0, 0));

	hlX = rtfTopPoint.X;
	hlY = rtfTopPoint.Y;
	hlWidth = monkey.richTextBox.Width;
	hlHeight = monkey.richTextBox.Height;

	rect1.X = 0;
	rect1.Y = 0;
	rect1.Width = hlWidth;
	rect1.Height = monkey.richTextBox.GetPositionFromCharIndex(start).Y;	

	rect2.X = 0;
	rect2.Y = monkey.richTextBox.GetPositionFromCharIndex(end).Y + lineHeight;
	rect2.Width = monkey.richTextBox.Width;
	rect2.Height = rtfBottomPoint.Y;
	
	if ( HIGHLIGHT_TYPE == "Sentence") {
		rect3.X = 0;
		rect3.Y = monkey.richTextBox.GetPositionFromCharIndex(start).Y;
		rect3.Width = monkey.richTextBox.GetPositionFromCharIndex(start).X;
		rect3.Height = lineHeight;	

		rect4.X = ((monkey.text.substring(end, end + 1) == "\n" || end >= monkey.text.Length) && monkey.selectionStart == end) ? hlWidth : monkey.richTextBox.GetPositionFromCharIndex(end).X;
		
		rect4.Y = monkey.richTextBox.GetPositionFromCharIndex(end).Y;
		rect4.Width = hlWidth - monkey.richTextBox.GetPositionFromCharIndex(end).X;
		rect4.Height = lineHeight;
	}
	else {
		rect3.Width = 0;
		rect3.Height = 0;
		rect4.Width = 0;
		rect4.Height = 0;
	}

	if (endPoint.Y + 1 < rtfTopPoint.Y) {
		rect1.Height = 0;
		rect2.Y = 0;
		rect2.Height = rtfBottomPoint.Y;
		
	} 
	else if (startPoint.Y + 1 < rtfTopPoint.Y) {
		rect1.Height = 0;
		rect2.Y = monkey.richTextBox.GetPositionFromCharIndex(end).Y + lineHeight;
		rect2.Height = rtfBottomPoint.Y;
		
	} 

	return [hlX, hlY, hlWidth, hlHeight];
};


// Util functions

var twipsToPixels = function(twips) {
	return System.Convert.ToInt32(twips / 15);
};

var getColorFromName = function(colorName) {
	// handle hex values
	if (colorName.indexOf("#") == 0) {
		return System.Drawing.ColorTranslator.FromHtml(colorName);
	} else {
		switch (colorName) {
			case "Paper":
				return monkey.paperColor;
			case "Ink":
				return monkey.inkColor;
			case "Dimmed":
				return monkey.dimmedColor;
			default:
				// handle color names
				return System.Drawing.Color.FromName(colorName);
		}
	}
};